<?php

namespace App\Http\Controllers\Api\Invoice;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Invoice\Invoice;

use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\InvoiceList as InvoiceListResource;
use App\Http\Resources\Invoice as InvoiceResource;




class InvoiceController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    
    function save(Request $request){
       
        $validator = Validator::make($request->all(), [
            'order_id' => 'required',
            'dateof' =>'required',
            'items' =>'required',
            'amount' =>'required',
            'grand_total' =>'required',
        ],  $this->message_errors());
        
        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
        $input['administer_id'] =  ownerKeyId(secret_key_get());
        $input['generatedBy'] = Auth::id();
        $input['order_id'] = decode($input['order_id']);
        $input['studentId'] = $this->getFieldOrder($input['order_id'], 'studentId');
        
        $pendingPayment = $this->is_pending($input['order_id'],'pendingPayment');
        
        
        if( $input['amount'] >  $pendingPayment){
              return response()->json(['error'=>'Invoice amount is greater then pending amount. Pending amount is: '.$pendingPayment], 401);       
        }
        $input['invoice_id'] = $this->getLastRecordInvoie();
        
        $data = new Invoice($input);
        if($data->save()){
            
            $notif['returnID'] = encode($data->id);
            
            $remainAmount = $pendingPayment - $input['amount'];
            $this->orderUpdate($input['order_id'],$remainAmount,$input['amount']);
        
            $notif['success'] = "Invoice has been created successfully";
            
            return response()->json($notif, $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function getFieldOrder($orderId=0,$fld='id'){
        $result = \App\Model\Api\Invoice\Orders::where('id',$orderId)->first();
        if(!empty($result)){
            return $result->$fld;
        }
    }
    function orderUpdate($orderId=0,$remainAmount=0,$invoicePayment=0){
        $totalPayment = $this->is_pending($orderId,'totalPaymentComplete');
        $info['pendingPayment'] = $remainAmount;
        $info['totalPaymentComplete'] = $totalPayment + $invoicePayment;
        if($remainAmount > 0){
            $info['status'] = 'Pending';
        }else{
            $info['status'] = 'Complete';
        }
        
        $data = \App\Model\Api\Invoice\Orders::find($orderId);
        $data->update($info);
        
    }
    public function is_pending($orderId=0,$fld){
        $result = \App\Model\Api\Invoice\Orders::where('id',$orderId)->first();
        if(!empty($result)){
            return $result->$fld;
        }
    }
    public function show($orderId=0){
        $orderId = decode($orderId);
        $admin_id = ownerKeyId(secret_key_get());
        $result = Invoice::where('administer_id',$admin_id)->where('order_id',$orderId)->get(); 
        
        $list['data'] =  InvoiceResource::collection($result);
        return response()->json(['success'=>$list], $this->successStatus);
    }
    function showList(Request $request){
        $admin_id = ownerKeyId(secret_key_get());
        $result = Invoice::where('administer_id',$admin_id)->get(); 
        
        
        $usersearch =0;
        $data['email']='';
        $data['phone']='';
        $data['student']='';
        if(count($request->all())){
            $query = Invoice::has('student')->with('student');
            if($request->has('phone')){
                $usersearch=1;
                $data['phone'] = $request->input('phone');
            }
            if($request->has('email')){
                $usersearch=1;
                $data['email'] = $request->input('email');
            }
            if($request->has('student')){
                $usersearch=1;
                $data['student'] = $request->input('student');
            }
            
            
            if($usersearch){
                $query = Invoice::whereHas('student', function($user) use($data){
                    if($data['phone']!=""){
                        $user->where('phone','like', '%'.$data['phone'].'%');
                    }
                    if($data['email']!=""){
                        
                        $user->whereRaw('LOWER(email) like ?',strtolower($data['email']));
                    }
                    if($data['student']!=""){
                        $user->where('id',decode($data['student']));
                    }
                })->with('user');
            }else{
                $query = Invoice::has('student')->with('student');
            }
            
            if($request->has('status')){
                $query->where('status_cancel',$request->input('status'));
            }
            if($request->has('invoiceId')){
                $query->where('invoice_id',$request->input('invoiceId'));
            }
            
            if($request->has('orderId')){
                $query->where('order_id',$request->input('orderId'));
            }
            
            $query->where('administer_id',$admin_id);
            
            $ordersQ = $query;
        }else{
           $ordersQ = Invoice::has('student')->with('student')->where('administer_id',$admin_id); 
        }
        
        if($request->get('page')){
            $list =  InvoiceListResource::collection($ordersQ->orderBy('id','desc')->paginate(10))->response()->getData();
        }else{
           $list['data'] =  InvoiceListResource::collection($ordersQ->get()); 
        }
        
        
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function single($orderId=0,$id=0){
        $id = decode($id);
        $orderId = decode($orderId);
        $admin_id = ownerKeyId(secret_key_get());
        $result = Invoice::where('administer_id',$admin_id)->where('order_id',$orderId)->where('id',$id)->get(); 
        $list['data'] =  InvoiceResource::collection($result);
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    function cancel(Request $request){
        $input = $request->all();
        $id = decode($input['id']);
        $orderId = decode($input['orderId']);
        $admin_id = ownerKeyId(secret_key_get());
        
        $invoice = Invoice::where('administer_id',$admin_id)->where('order_id',$orderId)->where('id',$id);
        $invoiceInfo = $invoice->first();
        
        
       
        $baseAmount = $invoiceInfo->amount;
        $tax1 = $invoiceInfo->taxAmount1;
        $tax2 = $invoiceInfo->taxAmount2;
        $grandTotal = $invoiceInfo->grand_total;
        
        $data['status_cancel'] = 1;
        $data['cancel_by'] = Auth::id();
        $data['notes'] = $input['notes'];
        if($invoice->update($data)){
            $this->orderRefundUpdate($orderId,$baseAmount,$tax1,$tax2,$grandTotal);
            return response()->json(['success'=>"Invoice has been cancel"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function orderRefundUpdate($orderId=0,$baseAmount=0,$tax1=0,$tax2=0,$grandTotal=0){
        
        $orderInfo = \App\Model\Api\Invoice\Orders::where("id",$orderId)->first();
        $info['pendingPayment'] = $orderInfo->pendingPayment + $baseAmount;
        $info['totalPaymentComplete'] = $orderInfo->totalPaymentComplete - $baseAmount;
        $info['status'] = 'Pending';
        //echo "<pre>"; print_r($info); echo "</pre>"; die();
        $data = \App\Model\Api\Invoice\Orders::find($orderId);
        $data->update($info);
        
    }
    
    function getLastRecordInvoie(){
        $invoice = Invoice::where('administer_id',ownerKeyId(secret_key_get()))->latest()->first();
        if(!empty($invoice)){
            return $invoice->invoice_id + 1;
        }else{
            return 1;
        }
    }
    function message_errors(){
        return [
            'order_id'=>'Order id required',
            'dateof'=>'Date of invoice required',
            'items'=>'At least one item required required',
            'amount'=>'Amount required',
            'grand_total'=>'Grand total required',
            
        ];
    }
    
}
