<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\Notification;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Notifications as NotificationsResource;





class NotificationController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    function create(Request $request){
       
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        
        if(Auth::user()->role == "4"){
            
            if($request->has('foruser')){
                if($request->input('foruser') == "agent"){
                    $input['to_id'] = Auth::user()->agent_id;
                }elseif($request->input('foruser') == "admin"){
                    $input['to_id'] = ownerKeyId(Auth::user()->owner_key);
                }
            }
            
            $input['from_id'] = Auth::id();
          
            $data = new Notification($input);
            if($data->save()){
                return response()->json(['success'=>"Notification has been created successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
         
            
            return response()->json(['success'=>"Notification has been created successfully"], $this->successStatus);
            
        }else{
            $input['to_id'] = decode($input['to_id']);
            $input['from_id'] = Auth::id();
            $data = new Notification($input);
            if($data->save()){
                return response()->json(['success'=>"Notification has been created successfully"], $this->successStatus);
            }else{
                 return response()->json(['error'=>'Error, Please try after some time.'], 401);
            }
        }
        
        
    }
   
    public function show(Request $request){
        $status=0;
        $query = Notification::where('to_id',Auth::id());
        if($request->has('status') && $request->get('status') !=""){
           $status = $request->get('status');
           if($status != "all"){
               $query->where('status',$status);
           }
        }
        if($request->get('page')){
            $list =  NotificationsResource::collection($query->orderBy('id','desc')->paginate(10))->response()->getData();
        }else{
            $list['data'] =  NotificationsResource::collection($query->orderBy('id','desc')->get());
        }
        
        
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function single($id=0){
        $id = decode($id);
        $list['data'] =  NotificationsResource::collection(Notification::where('to_id',Auth::id())->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }

    function status(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'status' => 'required|numeric',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        
        $data = Notification::where("id",$id);
        if($data->update($input)){
            return response()->json(['success'=>"Notifications status has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    
    function message_errors(){
        return [
            'title.required'=> 'Title Required',
            'assignTo.required'=> 'Agent id is not valid',
            'status.required'=> 'Status Required',
            'sendByinfo.in' => "Value should be [Student,Agent,Admin]",
        ];
    }
    
}
