<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class Documents extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            $this->mergeWhen(Auth::user()->isCompany(), [
                'id' => encode($this->id),
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
                'id' => encode($this->id),
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'id' => encode($this->id),
            ]),
            'docCategory' => $this->docCategory,
            'docTitle' => $this->docTitle,
            'docFiles'=>asset("uploads/document/". $this->docCategory.'/'. $this->docFiles),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
