<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class DocumentsAssign extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            
            $this->mergeWhen(Auth::user()->isCompany(), [
                'id' => encode($this->id),
                //'assignedByAgent' => ($this->assignedByAgent != "0" ?  $this->assigner->name .' '.$this->assigner->last_name:""),
                'assignedByAgentID' => ($this->assignedByAgent != "0" ? encode($this->assignedByAgent):""),
                'studentID' => encode($this->studentID),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'id' => encode($this->id),
                //'assignedByAgent' => ($this->assignedByAgent != "0" ?  $this->assigner->name .' '.$this->assigner->last_name:""),
                'assignedByAgentID' => ($this->assignedByAgent != "0" ? encode($this->assignedByAgent):""),
                'studentID' => encode($this->studentID),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
                'id' => encode($this->id),
                'assignBy' => ($this->assignedByAgent ==  Auth::id() ? "You":"Admin"),
                'studentID' => encode($this->studentID),
                'studentName' => $this->user->name.' '.$this->user->last_name,
            ]),
            $this->mergeWhen(Auth::user()->isClient(), [
                'id' => encode($this->id),
                "assigneddBy"=>($this->assignedByAgent == "0" ?"Admin":"Agent"),
                
            ]),
            'docID' => encode($this->docID),
            'docTitle' => $this->doc['docTitle'],
            'docCategory' => $this->doc['docCategory'],
            'docFileName'=>$this->doc['docFiles'],
            'docFiles'=>asset("uploads/document/". $this->doc['docCategory'].'/'. $this->doc['docFiles']),
            'docCustomerFile' => $this->docCustomer,
            'docCustomer' => asset("uploads/document/student/".$this->docCustomer),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
