<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class InvoiceSettings extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
           
            'id' => encode($this->id),
            'company'=>  $this->company,
            'service' => $this->service,
            'address' => $this->address,
            'email' => $this->email,
            'phone'=>  $this->phone,
            
            'taxLable1'=> $this->taxLable1,
            'taxNumber1' => $this->taxNumber1,
            'taxRate1' => $this->taxRate1,
            
            'taxLable2'=> $this->taxLable2,
            'taxNumber2' => $this->taxNumber2,
            'taxRate2' => $this->taxRate2,
            'prefix' => $this->prefix,
            'logoFile' => $this->companyLogo,
            'logoURL'=>asset("uploads/invoicelogo/"),
            
            'termsandcondition' => $this->termsandcondition,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
