<?php

namespace App\Http\Controllers\Api\Manager;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\User;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\Users as UserResource;

class StaffController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */   
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email', 
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }

        $input = $request->all();
        $input['password'] = Hash::make($input['password']);
        $input['owner_key']=secret_key_get();
        $input['role'] = 5;
        $input['status'] = 1;
        
        $user = User::create($input);
        $success['Authorization'] =  $user->createToken('MyApp')->accessToken;
        $success['name'] =  $user->name;
        $success['role'] = "Staff";
        $success['status'] = "Active";
        $success['staff_id'] = encode($user->id);
        return response()->json(['success'=>$success], $this->successStatus);
        
    }
    public function show(){
        $list['data'] =  UserResource::collection(User::where('owner_key',secret_key_get())->where('role',5)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    
    public function single($id=0){
        $id = decode($id);
        $single['data'] =  UserResource::collection(User::where('owner_key',secret_key_get())->where('id',$id)->where('role',5)->get());
        return response()->json(['success'=>$single], $this->successStatus);
    }
    public function edit(Request $request,$id){
        
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'name' => 'required', 'string', 'max:255',
            'email' => 'required|string|email|unique:users,email,'.$id, 
            'sex' => 'in:Male,Female',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
       
        
        $form_data = $request->all();
        if($request->input('new_password') !=""){
            $form_data['password'] = Hash::make($form_data['new_password']);
        }
        
        $data = User::find($id); 
        if($data->update($form_data)){
            return response()->json(['success'=>'Record has been updated successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function delete($id){
        $id = decode($id);
        $delete=  User::where("id",$id)->delete();
        if($delete){
            return response()->json(['success'=>'Record has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function message_errors(){
        return [
            'name.required'=> 'Name should not be blank',
            'name.max'=> 'Name should not be greated than 255 characters',
            'email.unique'=>'Email already exist',
            'email.email'=>'Invalid Email',
            'password.min'=>"Minimu 6 chracters",   
            'sex.in' => "Value should be [Male,Female]",
            
        ];
    }
}
