<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\DB;
use DateTime;
use Illuminate\Support\Facades\Mail;
use App\Library\PHPMailer;
use Illuminate\Support\Facades\File;
use Yajra\DataTables\Facades\DataTables;
use App\Http\Controllers\AjaxController;
use App\User;

class CommonController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $from;
    public $fromemail;
    public $reply;
    public $replyemail;
    protected $tax_rate=10;
    public function __construct(){ 
        $this->fromemail = \Illuminate\Support\Facades\Config::get('constants.emailsinfo.from');
        $this->from = \Illuminate\Support\Facades\Config::get('constants.emailsinfo.fromname');
        $this->replyemail = \Illuminate\Support\Facades\Config::get('constants.emailsinfo.reply');
        $this->reply = \Illuminate\Support\Facades\Config::get('constants.emailsinfo.replyname');
        
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    const METHOD = 'aes-256-ctr';
    
    function getRecord($table,$where=array()){
        $query= DB::table($table);
        if(!empty($where)){
            $query->where($where);
        }
        return $query->get();
        
    }
    function getRecordByField($table,$where=array(),$field){
        $query= DB::table($table);
        if(!empty($where)){
            $query->where($where);
        }
        $record = $query->first();       
        if($record){
           return $record->$field;
        }
        
    }
    function getRecordByFieldCount($table,$where=array()){
        $query= DB::table($table);
        if(!empty($where)){
            $query->where($where);
        }
        return  $query->count();       
        
        
    }
    function getRecordid($table,$id){
        return DB::table($table)->where('user_id',$id)->value('id');        
    }
    function requiredMsg($page='gen'){
        switch ($page){
            case 'gen':
                return '(required)';
                break;
        }
    }
    
   
    function dateManuplationGet($start,$end,$return=""){
        
            $dateOne = new DateTime($start);
            $dateTwo = new DateTime($end);
            
            $interval = $dateOne->diff($dateTwo);
            
            $minutes = $interval->format("%i");

            $hours = $interval->h;
            $hours = $hours + ($interval->days*24);
            $day=$interval->days; 
            $last_days=$interval->d;
            $seconds=$dateTwo->getTimestamp() - $dateOne->getTimestamp();
            if($return=="hour"){
                return $hours;
            }elseif($return=="day"){
                return $day;
            }elseif($return=="seconds"){
                return $seconds;
            }elseif($return=="minutes"){               
                return $minutes;
            }elseif($return=="last days"){
                return $last_days;
            }elseif($return=="equality"){
                
                if ($dateOne < $dateTwo)
                   return -1;  // lt
                 else if ($dateOne == $dateTwo)
                   return 0;  // eq
                 else if ($dateOne > $dateTwo)
                   return 1;  // gt
                 else
                   return "Nothing";
            }
            else{
                return $interval;
            }        
    }
    
    
   
    /*Ajax upload*/
    function pictureUploadProperty(Request $request){
        if($request->file('myfile')){   
            $name= $this->fileUpload($request->file('myfile'), 'uploads/'.$request->input('directory') );
            echo json_encode($name);
            die();
       }
    }
    function pictureDeleteProperty(Request $request){
            $destination = 'uploads/'.$request->input('directory')."/".$request->input("op");
            $this->fileDel($destination);
       
    }
    function pictureUpload(Request $request){
        if($request->file('myfile')){   
            $name= $this->fileUploadAjax($request->file('myfile'), 'uploads/' );
            echo json_encode($name);
            die();
       }
    }
    function fileUploadAjax($file,$destination){
            $destinationPath = $destination;            
            $temp = explode(".",$file->getClientOriginalName());
            $filenamename=  md5(rand(1, 1000).date("d/m/y h:i:s").'multi').'.'.end($temp);            
            $file->move($destinationPath,$filenamename);
            
            //$file->copy($destinationPath.'/'.$filenamename, $destinationPath.'/orginal/'.$filenamename);            
            $success = \File::copy($destinationPath.'/'.$filenamename,$destinationPath.'/orignal/'.$filenamename);
            return $filenamename;
    }
    
    /*End ajax**/
    
    /*Upload Picture*/
    function imageUploadSave(Request $request){
       if($request->file('myfile')){ 
            $path = "uploads/template/temp";            
            $name= $this->common->fileUpload($request->file('myfile'),  $path );
            return $name;
       }
    }
    function pictureDelete(Request $request){
        
            $destination = 'uploads/'.$request->input('action')."/".$request->input("name");
            //echo $destination; die();
            $this->fileDel($destination);
       
    }
    function fileUpload($file,$destination){
            $destinationPath = $destination;            
            /*$temp = explode(".",$file->getClientOriginalName());
            $filenamename=  md5(rand(1, 1000).date("d/m/y h:i:s").'multi').'.'.end($temp);            
            $file->move($destinationPath,$filenamename); */
            
            
            
            $count = count(glob($destinationPath . '/*' . $file->getClientOriginalName()));
            $fileRestName = str_replace(" ", "_", $file->getClientOriginalName());
            $filenamename = ($count > 0) ? $count . '-' . $fileRestName: $fileRestName;
            $file->move($destinationPath, $filenamename);
            return $filenamename;
    } 
    function fileDel($file){
        if(file_exists($file)){
            unlink($file);
        }
    }   
    
    function allowed_ext($type="media"){
        if($type=="file"){
            return array("application/pdf","application/msword","application/vnd.ms-excel","application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }elseif($type=="media"){
            return array("image/png","image/jpeg","image/jpg","image/gif");
        }elseif($type=="zip"){
            return array("application/octet-stream");
        }elseif($type=="zip&file"){
            return array("application/octet-stream","application/pdf","application/msword","application/vnd.ms-excel","application/vnd.openxmlformats-officedocument.wordprocessingml.document","application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }elseif($type=="audio"){
            return array(
                'mpeg', 'x-mpeg', 'mpeg3', 'x-mpeg-3', 'aiff', 
                'mid', 'x-aiff', 'x-mpequrl','midi', 'x-mid', 
                'x-midi','wav','x-wav','xm','x-aac','basic',
                'flac','mp4','x-matroska','ogg','s3m','x-ms-wax',
                'xm'
            );
        }
    }
    
    function filetypecheck($file_type,$allowed=array()){
        if(!in_array($file_type, $allowed)) {
          return 1;
        }else{
          return 0;
        }
    }

   
    function encode($val){
     return str_replace(array('+', '/','='), array('', '',''), strrev(substr(md5(999),3,4).base64_encode(strrev("`".$val."~".substr(md5($val),0,10).'p04b54'))));
    }

    function decode($code){
     $val = strrev(base64_decode(str_replace(array('', '',''), array('+', '/','='),strrev($code))));
     $val = ltrim(current(explode('~',$val)),'`');
     return $val;
    }
    function makeDirCheck($path){        
        if(!File::isDirectory($path)){
            File::makeDirectory($path, 0777, true, true);
            return $path;
        }else{
            return $path;
        }
    }
    
    function sendSMTPSystem($to,$subject="",$content="",$attachment=""){
        
        $hostname = env("MAIL_HOST", "");
        $port = env("MAIL_PORT", "");
        $username = env("MAIL_USERNAME","");
        $password = env("MAIL_PASSWORD", "");
        $secure = env("MAIL_ENCRYPTION", ""); 
        
       $mail = new PHPMailer(true);
       
       try{
            $mail->isSMTP();                                      // Set mailer to use SMTP
            $mail->Host = $hostname;  // Specify main and backup SMTP servers
            $mail->SMTPAuth = false;                               // Enable SMTP authentication
            $mail->Username = $username;                 // SMTP username
            $mail->Password = $password;                           // SMTP password
            $mail->SMTPSecure = $secure;                            // Enable TLS encryption, `ssl` also accepted
            $mail->Port = $port;
            $mail->protocol = 'mail';
            $mail->SMTPAuth = true;
            $mail->SMTPOptions = array(
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false,
                    'allow_self_signed' => true
                )
            );

            //Recipients
            $mail->setFrom($this->fromemail, $this->from);         
            $mail->addAddress($to);               // Name is optional 
            $mail->addReplyTo($this->replyemail, $this->reply);
           
            if($attachment!=""){
                $mail->addAttachment($attachment);
            }
            
            //Content
            $mail->isHTML(true);                                  // Set email format to HTML
            $mail->Subject = $subject;
            $mail->Body    = $content;
            $mail->AltBody = $content;  
           // echo "<pre>"; print_r($mail); die();
            $mail->send();
            return '1';
        } catch (Exception $e) {
            return 'Message could not be sent. Mailer Error: '. $e->getMessage();
        }
   }

   
   function redirectHome(){
       if(Auth::user()->role==1){
           return redirect(route("admin.home"));
       }elseif(Auth::user()->role==2){
           return redirect(route("user.home"));
       }
   }   
   
   function studentApiDocDeleteAll($id){
       $doc_biz = \App\Model\Api\DocBusiness::where('user_id',$id)->get();
        if(!empty($doc_biz)){
            foreach($doc_biz as $doc){
                if(!empty($doc)){
                    $docArr = json_decode($doc->businessDoc);
                    
                    foreach($docArr as $d){
                       
                        $this->fileDel('uploads/document/business/'.$d);
                    }
                }
                
            }
        }
        
        $doc_biz_delete = \App\Model\Api\DocBusiness::where('user_id',$id)->delete();
       
        
        $doc_other = \App\Model\Api\DocOther::where('user_id',$id)->get();
        if(!empty($doc_other)){
            foreach($doc_other as $doc){
                if(!empty($doc)){
                    $docArr = json_decode($doc->otherDoc);
                    foreach($docArr as $d){
                        $this->fileDel('uploads/document/others/'.$d);
                    }
                }
                
            }
        }
        \App\Model\Api\DocOther::where('user_id',$id)->delete();
        $doc_report = \App\Model\Api\DocCaReport::where('user_id',$id)->get();
        if(!empty($doc_report)){
            foreach($doc_report as $d){
                if($d->caReport!=""){
                    $this->fileDel('uploads/document/careport/'.$d->caReport);
                }
                
            }
        }
        \App\Model\Api\DocCaReport::where('user_id',$id)->delete();
        
        $doc_digital = \App\Model\Api\DocDegitalPicture::where('user_id',$id)->get();
        if(!empty($doc_digital)){
            foreach($doc_digital as $d){
                if($d->digitalPicture!=""){
                    $this->fileDel('uploads/document/digitalPicture/'.$d->digitalPicture);
                }
                
            }
        }
        \App\Model\Api\DocDegitalPicture::where('user_id',$id)->delete();
        
        $doc_education = \App\Model\Api\DocEducation::where('user_id',$id)->get();
        if(!empty($doc_education)){
            foreach($doc_education as $d){
                if($d->twelfthFile!=""){
                    
                }
                if($d->twelfth!=""){
                    $this->fileDel('uploads/document/education/'.$d->twelfth);
                }
                if($d->graduation!=""){
                    $this->fileDel('uploads/document/education/'.$d->graduation);
                }
                if($d->postGraduation!=""){
                    $this->fileDel('uploads/document/education/'.$d->postGraduation);
                }
                if($d->masters!=""){
                    $this->fileDel('uploads/document/education/'.$d->masters);
                }
                if($d->phd!=""){
                    $this->fileDel('uploads/document/education/'.$d->phd);
                }
                
                
                
                
            }
        }
        \App\Model\Api\DocEducation::where('user_id',$id)->delete();
        $doc_FUND = \App\Model\Api\DocFundProof::where('user_id',$id)->get();
        if(!empty($doc_FUND)){
            foreach($doc_FUND as $d){
                if($d->fundProof!=""){
                    $this->fileDel('uploads/document/fundproof/'.$d->fundProof);
                }
                
            }
        }
        \App\Model\Api\DocFundProof::where('user_id',$id)->delete();
        $doc_Identity = \App\Model\Api\DocIdentity::where('user_id',$id)->get();
        if(!empty($doc_Identity)){
            foreach($doc_Identity as $d){
                if($d->fundProof!=""){
                    
                }
                if($d->passportDoc!=""){
                    $this->fileDel('uploads/document/identity/'.$d->passportDoc);
                }
                if($d->nationalId!=""){
                    $this->fileDel('uploads/document/identity/'.$d->nationalId);
                }
                if($d->birthCertificate!=""){
                  $this->fileDel('uploads/document/identity/'.$d->birthCertificate);   
                }
                if($d->previousVisaStampPage!=""){
                    $this->fileDel('uploads/document/identity/'.$d->previousVisaStampPage);
                }
                
                
               
                
            }
        }
        \App\Model\Api\DocIdentity::where('user_id',$id)->delete();
        $doc_Resume = \App\Model\Api\DocResume::where('user_id',$id)->get();
        if(!empty($doc_Resume)){
            foreach($doc_Resume as $d){
                if($d->resume!=""){
                    $this->fileDel('uploads/document/resume/'.$d->resume);
                }
                
            }
        }
        \App\Model\Api\DocResume::where('user_id',$id)->delete();
        
        $retrainer = \App\Model\Api\RetrainerAgreement::where('studentID',$id)->get();
       
        if(!empty($retrainer)){
            foreach($retrainer as $d){
                if($d->agreementFile!=""){
                    $this->fileDel('uploads/document/retrainer_agreement/'.$d->agreementFile);
                }
                
            }
        }
        \App\Model\Api\RetrainerAgreement::where('studentID',$id)->delete();
   }
   
   
   
   /*Stripe Subscription*/
    function checkPaymentExpire($package='',$user_id=''){
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        
        $data = $user->subscription($package)->asStripeSubscription()->current_period_end;
        return date("Y-m-d H:i:s", $data);
    }
    
    function resumeSubscription($package='',$user_id=''){
        
        
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        
        $subscription = $user->subscription($package);

        if ($subscription->cancelled() && $subscription->onGracePeriod()) { 
            //if it was cancelled by user in grace period
            $subscription->resume();

            return true;
        } else { //if cancelled by payment failure or smth else...
            if($user->subscription($package)) {
                $user->newSubscription($package,
                        $user->subscription($package)->stripe_plan)
                    ->create();

                return true;
            } else {
                return false;
            }
        }
    }
    function is_subscribe($package = '',$user_id=''){
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        return $user->subscribed($package);
    }
    function is_cancelled($package='',$user_id=''){
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        return $user->subscription($package)->cancelled();
    }
    function cancelSubscriptionNow($package='',$user_id=''){
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        $user->subscription($package)->cancelNow();
    }
    function cancelSubscription($package='',$user_id=''){
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        $user->subscription($package)->cancel();
    }
    
    function get_active_subscription($user_id=''){
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        
       $subscribe =  $user->subscriptions()->active()->first();
       if(!empty($subscribe)){
           return $subscribe;
       }
    }
    function getPaymentMethod($user_id=''){
        if($user_id == ""){
            $user = User::find(Auth::id());
        }else{
            $user = User::find($user_id);
        }
        $paymentMethod = $user->defaultPaymentMethod();
        return $paymentMethod;
    }
    
    function invoice_save($invoice = array()){
        $data = new \App\Model\Invoice($invoice);
        $data->save();
        return $data->id;
    }
    
    function keyUpdateAll($oldKey,$newKey){
        $data['owner_key'] = $newKey;
        return User::where('owner_key',$oldKey)->update($data);
    }
    
    function docApplicationStatus($appId=0){
        $appId = decode($appId);
        $result = \App\Model\Api\Application::where('id',$appId)->whereIn('status',['New','Document Pending','Assigned'])->count();
        if($result){
            return 0;
        }else{
            return 1;
        }
    }
    function isApplicaitonYour($appId=0,$userId=0){
        $appId = decode($appId);
        $result = \App\Model\Api\Application::where('id',$appId)->where('user_id',$userId)->count();
        if($result){
            return 0;
        }else{
            return 1;
        }
    }
}
