<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;
use App\Http\Resources\LeadsLog as LeadslogResource;

class Leads extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => encode($this->id),
            'firstName' => $this->firstName,
            'lastName' => $this->lastName,
            'studentphoneNumber' => $this->phoneNumber,
            'studentEmail' =>$this->email,
            'studentDob' =>$this->dob,
            'studentCity'=>  $this->city,
            'studentCollege'=>  $this->college,
            'openBy' => getUserInfo($this->openBy,'name').' '.getUserInfo($this->openBy,'last_name'),
            'modiyfyBy' => getUserInfo($this->modifyBy,'name').' '.getUserInfo($this->modifyBy,'last_name'),
            'openByRole'=>roleName(getUserInfo($this->openBy,'role')),
            'source' => $this->source,
            'service'=>  $this->service,
            'serviceInformation'=>  $this->serviceInfo,
            'notes' => $this->notes,
            'actionSet' => $this->actionSet,
            "assignedTo" =>encode($this->assignedTo),
            'assignedToName' => getUserInfo($this->assignedTo,'name').' '.getUserInfo($this->assignedTo,'last_name'),
            'assignedToRole'=>roleName(getUserInfo($this->assignedTo,'role')),
           
            'status' =>  $this->status,
            'leadUniqueId'=>  $this->leadUnique_id,
            'appointmentBook' => $this->appointmentBook,
            'convertStatus'=>  $this->convertStatus,
            'startDate'=>  $this->startDate,
            'endDate'=>  $this->endDate,
            'convetBy'=>getUserInfo($this->convertBy,'name').' '.getUserInfo($this->convertBy,'last_name'),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'leadsLog'=> LeadslogResource::collection(\App\Model\Api\LeadsLog::where('leads_id',  $this->id)->orderBy('id','desc')->get())
        ];
    }
}
