<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Auth;

class NotesAdmin extends JsonResource
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
           
            'id' => encode($this->id),
            'postFrom'=>Auth::user()->name.' '.Auth::user()->last_name,
            $this->mergeWhen(Auth::user()->isCompany(), [
                'postToID' => encode($this->postTo),
                'postToName' => $this->user->name.' '.$this->user->last_name,
             ]),
            $this->mergeWhen(Auth::user()->isManager(), [
                'postToID' => encode($this->postTo),
                'postToName' => $this->user->name.' '.$this->user->last_name,
             ]),
            $this->mergeWhen(Auth::user()->isAgents(), [
                'postToID' => encode($this->postTo),
                'postToName' => $this->user->name.' '.$this->user->last_name,
             ]),
             $this->mergeWhen(Auth::user()->isAssociates(), [
                'postToID' => encode($this->postTo),
                'postToName' => $this->user->name.' '.$this->user->last_name,
             ]),
            'notes' => $this->notes,
            'attachmentURL'=>asset("uploads/notes/"),
            'attachmentFile'=>  $this->attachment,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
