<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\CommonController;
use Illuminate\Http\Request;
use Auth;
use App\Model\Api\NotesAdmin;
use Validator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Foundation\Auth\RegistersUsers;
use App\Http\Resources\NotesAdmin as NotesResource;




class NotesAdminController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public $successStatus = 200;
    protected $common;
    public function __construct(){  
        $this->common=new CommonController();
    }

    
    function create(Request $request){
        
        $validator = Validator::make($request->all(), [
            'postTo' => 'required',
            'notes' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        $input = $request->all();
        
        
        
        if(Auth::user()->role == "3"){
            $is_student = \App\User::where('id',  decode($input['postTo']))
                    ->where('role',4)
                    ->where('owner_key',Auth::user()->owner_key)
                    ->where('agent_id',Auth::id())
                    ->count();

            if(!$is_student){
                return response()->json(['error'=>"Invalid student id"], 401);       
            }
        }
        
        
        
        
        $input['postFrom']=Auth::id();
        $input['postTo'] = decode($input['postTo']);
        
        if($request->hasFile('attachment')){
           $input['attachment'] = $this->common->fileUpload($request->file('attachment'),'uploads/notes/');
        }
        
        
        $data = new NotesAdmin($input);
        if($data->save()){
            return response()->json(['success'=>"Notes has been posted successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    
    function update(Request $request,$id){
        $id = decode($id);
        $validator = Validator::make($request->all(), [
            'postTo' => 'required',
            'notes' => 'required',
        ],  $this->message_errors());

        if ($validator->fails()) {
            return response()->json(['error'=>$validator->errors()], 401);            
        }
        
        $input = $request->all();
        
        if(Auth::user()->role == "3"){
            $is_student = \App\User::where('id',  decode($input['postTo']))
                    ->where('role',4)
                    ->where('owner_key',Auth::user()->owner_key)
                    ->where('agent_id',Auth::id())
                    ->count();

            if(!$is_student){
                return response()->json(['error'=>"Invalid student id"], 401);       
            }
        }
        
        $input['postTo'] = decode($input['postTo']);
        
        if($request->hasFile('attachment')){
           $input['attachment'] = $this->common->fileUpload($request->file('attachment'),'uploads/notes/');
        }
        $data = NotesAdmin::find($id);
        if($data->update($input)){
            return response()->json(['success'=>"Note has been updated successfully"], $this->successStatus);
        }else{
             return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
    }
    function single($id){
        $id = decode($id);
        
        if(Auth::user()->role == "3"){
            $is_student = \App\User::where('id',  $id)
                    ->where('role',4)
                    ->where('owner_key',Auth::user()->owner_key)
                    ->where('agent_id',Auth::id())
                    ->count();

            if(!$is_student){
                return response()->json(['error'=>"Invalid student id"], 401);       
            }
        }
        
        $list['data'] =  NotesResource::collection(NotesAdmin::has('user')->with('user')->where('postFrom',Auth::id())->where('id',$id)->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function show($studentId=0){
        $studentId = decode($studentId);
        
        
        if(Auth::user()->role == "3"){
            $is_student = \App\User::where('id',  $studentId)
                    ->where('role',4)
                    ->where('owner_key',Auth::user()->owner_key)
                    ->where('agent_id',Auth::id())
                    ->count();

            if(!$is_student){
                return response()->json(['error'=>"Invalid student id"], 401);       
            }
        }
        
        $list['data'] =  NotesResource::collection(NotesAdmin::has('user')->with('user')->where('postTo',$studentId)->where('postFrom',Auth::id())->orderBy('id','DESC')->get());
        return response()->json(['success'=>$list], $this->successStatus);
    }
    public function delete($id){
        $id = decode($id);
        
        if(Auth::user()->role == "3"){
            $is_student = \App\User::where('id',  $id)
                    ->where('role',4)
                    ->where('owner_key',Auth::user()->owner_key)
                    ->where('agent_id',Auth::id())
                    ->count();

            if(!$is_student){
                return response()->json(['error'=>"Invalid student id"], 401);       
            }
        }
        
        $delete = NotesAdmin::where('postFrom',Auth::id())->where('id',$id)->delete();
        if($delete){
            return response()->json(['success'=>'Note has been deleted successfully'], $this->successStatus);
        }else{
            return response()->json(['error'=>'Error, Please try after some time.'], 401);
        }
        
    }
    function message_errors(){
        return [
            'postTo.required'=> 'postTo ID is required',
            'notes.required'=> 'Notes value is required',
        ];
    }
    
}
