<?php

namespace App\Model\Api;
use Illuminate\Database\Eloquent\Model;
use Auth;

class Application extends Model{


   protected $table="application";
   protected $fillable=[
       'user_id',
       'administer_id',
       'applyFor',
       'assignTo',
       'applyForOther',
       'status',
       'details',
       'upload_decision_doc',
       'expire_date',
       'fee',
       'application_number',
       'decision_date',

       'date_retained',
       'priority',
       'office_application_number',
       'officelocation',
       'date_submit_to_cic',
       'cic_application_no',
       'decision',
       'additional_notes',
       'submitted_to_cic_before_due_date'
   ];

   function user(){
        $query =  $this->belongsTo('App\User','user_id','id');
        if(Auth::user()->role == 2){
            $query->where('owner_key',Auth::user()->secret_key);
        }elseif (Auth::user()->role == 3){
            $query->where('owner_key',Auth::user()->owner_key);
            $query->where('agent_id',Auth::id());
        }elseif (Auth::user()->role == 5){
            $query->where('owner_key',Auth::user()->owner_key);
        }elseif (Auth::user()->role == 6){
            $query->where('owner_key',Auth::user()->owner_key);
        }
        return $query;
   }

   function userCron(){
        $query =  $this->belongsTo('App\User','user_id','id');
        return $query;
   }

}
