@extends('layouts.default')
@section('title','Package - Edit')
@section('header_extra')
<link href="{{asset('assets/plugins/summernote/summernote.css')}}" rel="stylesheet" />
@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Package Edit</b></h4>
            <p class="text-muted m-b-30 font-14">
                Required Fields (<code>*</code>)
            </p>

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        @include('widget/notifications')
                        @if ($errors->any())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        
                        <form class="form-horizontal validate" action="{{route('admin.package.edit_update',$r->id)}}" method="post" role="form" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" id="rid" value="{{Auth::id()}}">
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Package Stripe ID <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="stripe_id" class="form-control" required value="{{$r->stripe_id}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Name <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="name" class="form-control" required value="{{$r->name}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Duration <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="duration" class="form-control" required=""  value="{{$r->duration}}">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label class="col-2 col-form-label">Price <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="number" step="any" name="price" required="" class="form-control" value="{{$r->price}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Tax <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="number" step="any" name="tax" required="" class="form-control" value="{{$r->tax}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Grand Amount <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="number" step="any" name="grand" required="" class="form-control" value="{{$r->grand}}">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Description <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <textarea class="summernote" name="description">{{$r->description}}</textarea>
                                </div>
                            </div>
                            
                            
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Submit
                                    </button>
                                    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script type="text/javascript" src="{{asset('assets/plugins/parsleyjs/parsley.min.js')}}"></script>
<script src="{{asset('assets/plugins/summernote/summernote.min.js')}}"></script>
<script type="text/javascript">
    $('.validate').parsley();
    $(function(){
        $(this).active_menu("subscription");
        
        
    });
    $('.summernote').summernote({
        height: 350,                 // set editor height
        minHeight: null,             // set minimum height of editor
        maxHeight: null,             // set maximum height of editor
        focus: false                 // set focus to editable area after initializing summernote
    });
    
</script>
@stop