@extends('layouts.app')

@section('content')
<section>
<div class="container">
    <div class="row">
        <div class="col-sm-12">

            <div class="wrapper-page">

                <div class="account-pages">
                    <div class="account-box">
                        <div class="account-logo-box">
                            <h2 class="text-uppercase text-center">
                                <a href="javascript:void(0)" class="text-success">
                                    <span><img src="{{asset('assets/images/logo_dark.png')}}" alt="" height="30"></span>
                                </a>
                            </h2>
                        </div>
                        <div class="account-content">
                            
                            <div class="text-center m-b-20">
                                <p class="text-muted m-b-0">Enter your email address and we'll send you an email with instructions to reset your password.  </p>
                            </div>
                            @include('widget/notifications')
                            <form class="form-horizontal" action="{{ route('password.update') }}" method="post">
                                @csrf
                                <input type="hidden" name="token" value="{{ $token }}">
                                <div class="form-group m-b-20 row @error('email') has-danger @enderror">
                                    <div class="col-12">
                                        <label for="emailaddress">Email address</label>
                                       
                                        <input id="email" type="email" class="form-control @error('email') form-control-danger @enderror" name="email"  required autocomplete="email" autofocus>
                                        
                                        @error('email')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-group row m-b-20 @error('email') has-danger @enderror">
                                    <div class="col-12">
                                        
                                        <label for="password">New Password</label>
                                        <input id="password" type="password" class="form-control @error('password') form-control-danger @enderror" name="password" required autocomplete="new-password">

                                        @error('password')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="form-group row m-b-20">
                                    <div class="col-12">
                                        
                                        <label for="password">Confirm Password</label>
                                        <input id="password-confirm" type="password" class="form-control " name="password_confirmation" required  >

                                        
                                    </div>
                                </div>

                                

                                <div class="form-group row text-center m-t-10">
                                    <div class="col-12">
                                        <button class="btn btn-md btn-block btn-primary waves-effect waves-light" type="submit">Reset Password</button>
                                    </div>
                                </div>

                            </form>
                            

                        </div>
                    </div>
                </div>
                <!-- end card-box-->


            </div>
            <!-- end wrapper -->

        </div>
    </div>
</div>
</section>
@endsection
