@extends('layouts.app')

@section('content')
<section>
<div class="container">
    <div class="row">
        <div class="col-sm-12">

            <div class="wrapper-page">

                <div class="account-pages">
                    <div class="account-box">
                        <div class="account-logo-box">
                            <h2 class="text-uppercase text-center">
                                <a href="javascript:void(0)" class="text-success">
                                    <span><img src="{{asset('assets/images/logo_dark.png')}}" alt="" height="30"></span>
                                </a>
                            </h2>
                            <h5 class="text-uppercase font-bold m-b-5 m-t-50">Register</h5>
                            
                            
                        </div>
                        <div class="account-content">
                            @include('widget/notifications')
                            <form class="form-horizontal" action="{{ route('register') }}" method="post">
                                @csrf
                                <div class="form-group m-b-20 row @error('name') has-danger @enderror">
                                    
                                        <label for="emailaddress">First Name <code>*</code></label>
                                       
                                        <input  type="text" class="form-control @error('name') form-control-danger @enderror" name="name" value="{{ old('name') }}" required  autofocus>
                                        
                                        @error('name')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    
                                </div>
                                
                                <div class="form-group m-b-20 row">
                                    
                                        <label for="emailaddress">Last Name</label>
                                       
                                        <input  type="text" class="form-control" name="last_name" value="{{ old('last_name') }}" >
                                        
                                    
                                </div>
                                <div class="form-group m-b-20 row @error('email') has-danger @enderror">
                                   
                                        <label for="emailaddress">Email address</label>
                                       
                                        <input id="email" type="email" class="form-control @error('email') form-control-danger @enderror" name="email" value="{{ old('email') }}" required autocomplete="email" autofocus>
                                        
                                        @error('email')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    
                                </div>
                                
                                <div class="form-group m-b-20 row">
                                    <label >Phone <span class="text-danger">*</span></label>
                                    
                                        <input type="text" name="phone" required="" class="form-control" value="{{old('phone')}}">
                                    
                                </div>
                                <div class="form-group m-b-20 row">
                                    <label > Address <span class="text-danger">*</span></label>
                                   
                                        <input type="text" name="address" class="form-control" required value="{{old('address')}}">
                                    
                                </div>
                                <div class="form-group m-b-20 row">
                                    <label >City <span class="text-danger">*</span></label>
                                        <input type="text" name="city" required="" class="form-control" value="{{old('city')}}">
                                </div>
                                <div class="form-group m-b-20 row">
                                    <label >Province <span class="text-danger">*</span></label>
                                        <input type="text" name="state" required="" class="form-control" value="{{old('state')}}">
                                </div>
                                <div class="form-group m-b-20 row">
                                    <label >Country <span class="text-danger">*</span></label>
                                     <select name="country" class="form-control" required>
                                        <option value="">Select Country</option>
                                        @if(!empty(country()))
                                        @foreach(country() as $c)
                                        <option  value="{{$c->iso}}">{{$c->nicename}}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                </div>

                                <div class="form-group m-b-20 row">
                                    <label >Company Name <span class="text-danger">*</span></label>
                                    <input type="text" name="company_name" class="form-control" required value="{{old('company_name')}}">
                                  
                                </div>
                                <div class="form-group m-b-20 row">
                                    <label >Number of employee</label>
                                    <input type="number" min="1" name="number_employee" class="form-control" value="{{old('number_employee')}}">
                                </div>
                                
                                
                                

                                <div class="form-group row m-b-20 @error('password') has-danger @enderror">
                                    
                                        
                                        <label for="password">Password</label>
                                        <input id="password" type="password" class="form-control @error('password') form-control-danger @enderror" name="password" required autocomplete="current-password">

                                        @error('password')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    
                                </div>
                                
                                <div class="form-group row m-b-20 @error('password') has-danger @enderror">
                                    
                                        
                                        <label for="password">Confirm Password</label>
                                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="confirm-password" >

                                        @error('password')
                                            <div class="form-control-feedback">{{ $message }}</div>
                                        @enderror
                                    
                                </div>

                                

                                <div class="form-group row text-center m-t-10">
                                   
                                        <button class="btn btn-md btn-block btn-primary waves-effect waves-light" type="submit">Register</button>
                                    
                                </div>

                            </form>
                            

                        </div>
                    </div>
                </div>
                <!-- end card-box-->


            </div>
            <!-- end wrapper -->

        </div>
    </div>
</div>
</section>
@endsection
