@extends('layouts.default')
@section('title','Set Up Fee')
@section('header_extra')
<style>
    #card-errors{
        color: red;
        margin-top: 5px;
        font-weight: bold;
    }
</style>
@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Setup Portal Cost</b></h4>
            

            <div class="row">
                 <div class="col-lg-5 col-xs-12">
                    <div class="p-20">
                        @include('widget/notifications')
                        
                        <form id="paymentForm" class="form-horizontal" action="{{route('customer.payment.setup_cost_save')}}" method="post">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">
                        <div class="form-group row">
                            <h4>Enter Credit Card Details</h4>
                        </div>
                        <div class="form-group row">
                            <div id="card-errors" role="alert"></div>
                        </div>
                        <div class="form-group row">
                            <label>Card Holder Name <span class="text-danger">*</span></label>
                            <input id="card-holder-name" type="text" class="form-control" required="">
                        </div>

                        <div class="form-group row">
                            <!-- Stripe Elements Placeholder -->
                            <div id="card-element" class="form-control" style='height: 2.4em; padding-top: .7em;'></div>
                            
                        </div>
                        <div class="form-group row">
                        <button id="card-button" class="btn btn-success" type="button">
                            Process Payment
                        </button>
                        </div>
                            
                    </div>

                        
                        </form>
                    </div>
                    <div class="col-lg-1 col-xs-12"></div>
                    <div class="col-lg-5 col-xs-12">
                        <h4 class="m-b-10">Service Details</h4>
                        <table class="table table-bordered">
                            <tr>
                                <th>Service</th>
                                <td>One Time Setup Cost</td>
                            </tr>
                            <tr>
                                <th>Package Name</th>
                                <td>{{$package->name}}</td>
                            </tr>
                            <tr>
                                <th>Duration</th>
                                <td>{{$package->duration}}</td>
                            </tr>
                            <tr>
                                <th>Price</th>
                                <td>{{$package->price}}</td>
                            </tr>
                            <tr>
                                <th>Tax</th>
                                <td>{{$package->tax}}</td>
                            </tr>
                            <tr>
                                <th>Total</th>
                                <td>{{$package->grand}}</td>
                            </tr>
                       </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script type="text/javascript" src="{{asset('assets/plugins/parsleyjs/parsley.min.js')}}"></script>
<script type="text/javascript">
$(function(){
    $(this).active_menu("setupcost");
})
</script>

<script src="https://js.stripe.com/v3/"></script>

<script>
    const stripe = Stripe('{{ env("STRIPE_KEY") }}', { locale: 'en' }); // Create a Stripe client.

    const elements = stripe.elements();
    const cardElement = elements.create('card', {hidePostalCode: true});

    cardElement.mount('#card-element');
    // Handle real-time validation errors from the card Element.
    cardElement.addEventListener('change', function(event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });
    
    const cardHolderName = document.getElementById('card-holder-name');
const cardButton = document.getElementById('card-button');

cardButton.addEventListener('click', async (e) => {
    if(cardHolderName.value == ""){
        var errorElement = document.getElementById('card-errors');
       errorElement.textContent = "Please enter card holder name";
       return false;
    }
    const { paymentMethod, error } = await stripe.createPaymentMethod(
         
        'card', cardElement, {
          billing_details: { name: cardHolderName.value,address:{'line1':"{{Auth::user()->address}}",postal_code:'{{Auth::user()->zipcode}}',city:'{{Auth::user()->city}}',state:'{{Auth::user()->state}}',country:"{{Auth::user()->country}}"} }
        },
        
        
    );
    
    if (error) {
       var errorElement = document.getElementById('card-errors');
       errorElement.textContent = error.message;
    } else {
        stripeTokenHandler(paymentMethod.id);
    }
    
    
    
});

function stripeTokenHandler(paymentMethod) {
        
        // Insert the token ID into the form so it gets submitted to the server
        var form = document.getElementById('paymentForm');
        var hiddenInput = document.createElement('input');
        hiddenInput.setAttribute('type', 'hidden');
        hiddenInput.setAttribute('name', 'paymentMethod');
        hiddenInput.setAttribute('value', paymentMethod);
        form.appendChild(hiddenInput);

        // Submit the form
        form.submit();
    }
</script>

<!--<script src="https://cdnjs.cloudflare.com/ajax/libs/formvalidation/0.6.2-dev/js/formValidation.min.js" integrity="sha512-DlXWqMPKer3hZZMFub5hMTfj9aMQTNDrf0P21WESBefJSwvJguz97HB007VuOEecCApSMf5SY7A7LkQwfGyVfg==" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/formvalidation/0.6.2-dev/js/framework/bootstrap.min.js" integrity="sha512-CwWsnPwntKMVNsVVCKIxPd4Ievk/YyAxt/yFNOLbs4JH3W6djpxYf2G50DtxLxFGHIbZxXeVDyjmTT8RCNp8DQ==" crossorigin="anonymous"></script>

<script type="text/javascript">
$(document).ready(function() {
    // Change the key to your one
    

    $('#paymentForms')
        .formValidation({
            framework: 'bootstrap',
            icon: {
                valid: 'glyphicon glyphicon-ok',
                invalid: 'glyphicon glyphicon-remove',
                validating: 'glyphicon glyphicon-refresh'
            },
            fields: {
                name: {
                    validators: {
                        notEmpty: {
                            message: 'The name is required'
                        }
                    }
                },
                email: {
                    validators: {
                        notEmpty: {
                            message: 'The email is required'
                        }
                    }
                },
                password: {
                    validators: {
                        notEmpty: {
                            message: 'The password is required'
                        }
                    }
                },
                ccNumber: {
                    selector: '[data-stripe="number"]',
                    validators: {
                        notEmpty: {
                            message: 'The credit card number is required'
                        },
                        creditCard: {
                            message: 'The credit card number is not valid'
                        }
                    }
                },
                expMonth: {
                    selector: '[data-stripe="exp-month"]',
                    row: '.col-xs-3',
                    validators: {
                        notEmpty: {
                            message: 'The expiration month is required'
                        },
                        digits: {
                            message: 'The expiration month can contain digits only'
                        },
                        callback: {
                            message: 'Expired',
                            callback: function(value, validator) {
                                value = parseInt(value, 10);
                                var year         = validator.getFieldElements('expYear').val(),
                                    currentMonth = new Date().getMonth() + 1,
                                    currentYear  = new Date().getFullYear();
                                if (value < 0 || value > 12) {
                                    return false;
                                }
                                if (year == '') {
                                    return true;
                                }
                                year = parseInt(year, 10);
                                if (year > currentYear || (year == currentYear && value >= currentMonth)) {
                                    validator.updateStatus('expYear', 'VALID');
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                },
                expYear: {
                    selector: '[data-stripe="exp-year"]',
                    row: '.col-xs-3',
                    validators: {
                        notEmpty: {
                            message: 'The expiration year is required'
                        },
                        digits: {
                            message: 'The expiration year can contain digits only'
                        },
                        callback: {
                            message: 'Expired',
                            callback: function(value, validator) {
                                value = parseInt(value, 10);
                                var month        = validator.getFieldElements('expMonth').val(),
                                    currentMonth = new Date().getMonth() + 1,
                                    currentYear  = new Date().getFullYear();
                                if (value < currentYear || value > currentYear + 100) {
                                    return false;
                                }
                                if (month == '') {
                                    return false;
                                }
                                month = parseInt(month, 10);
                                if (value > currentYear || (value == currentYear && month >= currentMonth)) {
                                    validator.updateStatus('expMonth', 'VALID');
                                    return true;
                                } else {
                                    return false;
                                }
                            }
                        }
                    }
                },
                cvvNumber: {
                    selector: '[data-stripe="cvc"]',
                    validators: {
                        notEmpty: {
                            message: 'The CVV number is required'
                        },
                        cvv: {
                            message: 'The value is not a valid CVV',
                            creditCardField: 'ccNumber'
                        }
                    }
                }
            }
        })
        .on('success.form.fv', function(e) {
           console.log("Run")
            var $form = $(e.target);
            $form.submit();
        });
});

</script>-->

@stop