@extends('layouts.default')
@section('title','Credit Card Update For Subscription')
@section('header_extra')
<style>
    #card-errors{
        color: red;
        margin-top: 5px;
        font-weight: bold;
    }
</style>
@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Credit Card Update For Subscription</b></h4>
            

            <div class="row">
                <div class="col-6 mx-auto">
                    <div class="p-20">
                        @include('widget/notifications')
                        
                        <form id="paymentForm" class="form-horizontal" action="{{route('customer.payment.update_card_save')}}" method="post">
                        <input type="hidden" name="_token" value="{{csrf_token()}}">

                        <div class="form-group row">
                            <div id="card-errors" role="alert"></div>
                        </div>
                        <div class="form-group row">
                            <label>Card Holder Name <span class="text-danger">*</span></label>
                            <input id="card-holder-name" type="text" class="form-control" required="">
                        </div>

                        <div class="form-group row">
                            <!-- Stripe Elements Placeholder -->
                            <div id="card-element" class="form-control" style='height: 2.4em; padding-top: .7em;'></div>
                            
                        </div>
                            
                       <div class="form-group">
                            <div class="col-xs-9 col-xs-offset-3">
                                <button id="card-button" type="submit" class="btn btn-primary" data-secret="{{ $intent->client_secret }}">Update Card</button> &nbsp;
                                <a href="{{route('customer.profile')}}" class="btn btn-success">Back to profile</a>
                            </div>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/formvalidation/0.6.2-dev/js/formValidation.min.js" integrity="sha512-DlXWqMPKer3hZZMFub5hMTfj9aMQTNDrf0P21WESBefJSwvJguz97HB007VuOEecCApSMf5SY7A7LkQwfGyVfg==" crossorigin="anonymous"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/formvalidation/0.6.2-dev/js/framework/bootstrap.min.js" integrity="sha512-CwWsnPwntKMVNsVVCKIxPd4Ievk/YyAxt/yFNOLbs4JH3W6djpxYf2G50DtxLxFGHIbZxXeVDyjmTT8RCNp8DQ==" crossorigin="anonymous"></script>
<!--<script src="https://js.stripe.com/v2/"></script>-->
<script type="text/javascript">
$(function(){
    $(this).active_menu("profile");
})
</script>

<script src="https://js.stripe.com/v3/"></script>
<script>
    // Custom styling can be passed to options when creating an Element.
    // (Note that this demo uses a wider set of styles than the guide below.)
    var style = {
        base: {
            color: '#32325d',
            lineHeight: '18px',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };

    const stripe = Stripe('{{ env("STRIPE_KEY") }}', { locale: 'en' }); // Create a Stripe client.
    const elements = stripe.elements(); // Create an instance of Elements.
    const cardElement = elements.create('card', {hidePostalCode: true}, { style: style }); // Create an instance of the card Element.
    const cardButton = document.getElementById('card-button');
    const clientSecret = cardButton.dataset.secret;
    const cardHolderName = document.getElementById('card-holder-name');
    cardElement.mount('#card-element'); // Add an instance of the card Element into the `card-element` <div>.
    
    // Handle real-time validation errors from the card Element.
    cardElement.addEventListener('change', function(event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });

    // Handle form submission.
    var form = document.getElementById('paymentForm');

    form.addEventListener('submit', function(event) {
        event.preventDefault();

        stripe
            .handleCardSetup(clientSecret, cardElement, {
                payment_method_data: {
                    billing_details: { name: cardHolderName.value,address:{'line1':"address",postal_code:'01880',city:'New York',state:'CA',country:"US"} }
                }
            })
            .then(function(result) {
                console.log(result);
                if (result.error) {
                    // Inform the user if there was an error.
                    var errorElement = document.getElementById('card-errors');
                    errorElement.textContent = result.error.message;
                } else {
                    console.log(result);
                    // Send the token to your server.
                    stripeTokenHandler(result.setupIntent.payment_method);
                }
            });
    });

    // Submit the form with the token ID.
    function stripeTokenHandler(paymentMethod) {
        // Insert the token ID into the form so it gets submitted to the server
        var form = document.getElementById('paymentForm');
        var hiddenInput = document.createElement('input');
        hiddenInput.setAttribute('type', 'hidden');
        hiddenInput.setAttribute('name', 'paymentMethod');
        hiddenInput.setAttribute('value', paymentMethod);
        form.appendChild(hiddenInput);

        // Submit the form
        form.submit();
    }
</script>

@stop