@extends('layouts.default')
@section('title','Secret Key')
@section('header_extra')
@stop

@section('content')


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Secret Key</b></h4>
            

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        @include('widget/notifications')
                        @if(Auth::user()->secret_key !="")
                        <form class="form-horizontal validate" action="#">
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Secret Key:</label>
                                <div class="col-8">
                                    <input disabled="" type="text" class="form-control" value="{{Auth::user()->secret_key}}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    
                                    <a href="{{route('customer.key_generate')}}" class="btn btn-primary waves-effect waves-light">
                                        Re-Generate Key
                                    </a>
                                    
                                </div>
                            </div>
                        </form>
                        @else
                        <?php $active_subscription =  get_active_subscription(); ?>
                            @if(!empty($active_subscription))
                            <a href="{{route('customer.key_generate')}}" class="btn btn-primary waves-effect waves-light">
                                Generate Key
                            </a>
                            @else
                            <h3>Please purchase a subscription to get a key</h3>
                            @endif
                        @endif
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script type="text/javascript" src="{{asset('assets/plugins/parsleyjs/parsley.min.js')}}"></script>
<script type="text/javascript" src="{{asset('assets/js/custom.js')}}"></script>
<script type="text/javascript">
    $(function(){
        $(this).active_menu("secret_key");
    })
    
</script>
@stop