@extends('layouts.default')
@section('title','My Profile')
@section('header_extra')
@stop

@section('content')
<div class="row">
    
    
    <div class="col-sm-12">
        <div class="profile-bg-picture" style="background-image:url(' {{asset('assets/images/bg-profile.jpg')}} ')">
            <span class="picture-bg-overlay"></span><!-- overlay -->
        </div>
        <!-- meta -->
        <div class="profile-user-box">
            <div class="row">
                <div class="col-sm-4">
                    <span class="pull-left m-r-15">
                        @if($r->picture!="")
                        <img src="{{asset('uploads/profile/'.$r->picture)}}" alt="" class="thumb-lg rounded-circle">
                        @endif
                    </span>
                    <div class="media-body">
                        <h4 class="m-t-5 m-b-5 font-18 ellipsis">{{$r->name.' '.$r->last_name}}</h4>
                        <p class="font-13"> Admin</p>
                        <p class="text-muted m-b-0"><small>{{$r->state. ' '.$r->country}}</small></p>
                    </div>
                </div>
                <div class="col-sm-4">
                    
                    @if($r->subscribe_date!="")
                    <div class="text-center">
                        <h4>{!! is_expire_html(date('Y-m-d',strtotime($r->subscribe_date))) !!}</h4>
                        <h4>  
                            <span class="label label-success">Subscription Date: {{date('m-d-Y',strtotime($r->subscribe_date))}}</span>
                        </h4>
                    </div>
                    @else
                    <div class="text-center"><h4> <span class="label label-danger">Still not purchase subscription</span></h4></div>
                    @endif
                </div>
                <div class="col-sm-4">
                    <div class="text-right">
                        @if($r->secret_key=="")
                        <a href="{{route('admin.user.key_generate',$r->id)}}" class="btn btn-success waves-effect waves-light">
                            <i class="fa fa-key m-r-5"></i> 
                            Generate Keys
                        </a>
                        @else
                        <a href="{{route('admin.user.key_generate',$r->id)}}" class="btn btn-success waves-effect waves-light">
                            <i class="fa fa-key m-r-5"></i> 
                            Re-Generate Keys
                        </a>
                        @endif
                    </div>
                </div>
                
            </div>
        </div>
        <!--/ meta -->
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <!-- Personal-Information -->
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Personal Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Full Name :</strong> <span class="m-l-15">{{$r->name.' '.$r->last_name}}</span></p>

                    <p class="text-muted font-13"><strong>Mobile :</strong><span class="m-l-15">{{$r->phone}}</span></p>

                    <p class="text-muted font-13"><strong>Email :</strong> <span class="m-l-15">{{$r->email}}</span></p>

                    <p class="text-muted font-13"><strong>Address :</strong> <span class="m-l-15">{{$r->address}}</span></p>

                    <p class="text-muted font-13"><strong>City :</strong> <span class="m-l-15">{{$r->city}}</span></p>
                    <p class="text-muted font-13"><strong>State :</strong> <span class="m-l-15">{{$r->state}}</span></p>
                    <p class="text-muted font-13"><strong>Country :</strong> <span class="m-l-15">{{$r->country}}</span></p>
                    <p class="text-muted font-13"><strong>Zip Code :</strong> <span class="m-l-15">{{$r->zipcode}}</span></p>
                    <p class="text-muted font-13"><strong>Status :</strong> 
                        <span class="m-l-15">
                            @if($r->status == "1")
                            <span class="label label-success">Active</span>
                            @elseif($r->status == "0")
                            <span class="label label-danger">Disable</span>
                            @endif
                            
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <!-- Personal-Information -->

        

    </div>

    <div class="col-md-6">
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Status Update</h4>
            <div class="panel-body">
                
                
                
                <form class="form-horizontal validate" action="{{route('admin.user.edit_update',$r->id)}}" method="post" role="form" enctype="multipart/form-data">
                    @csrf
                    @include('widget/notifications')
                    <div class="form-group row">
                        <label class="col-2 col-form-label">Status</label>
                        <div class="col-8">
                            <select class="form-control" name="status">
                                <option value="1" {{($r->status == "1" ? "selected":"")}}>Active</option>
                                <option value="0" {{($r->status == "0" ? "selected":"")}}>De-Active</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group row">
                        <div class="col-8 offset-4">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                Submit
                            </button>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- end col -->

</div>
<div class="row">
    <div class="col-md-12">
        <!-- Personal-Information -->
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Orders</h4>
            <div class="panel-body">
                <table class="table table-bordered">
                    <tr>
                        <th>ID</th>
                        <th>Payment</th>
                        <th>Transaction ID</th>
                        <th>Payment Status</th>
                        <th>Status</th>
                    </tr>
                    @if(!empty($order))
                    @foreach($order as $o)
                    <tr>
                        <td>{{$o->id}}</td>
                        <td>{{$o->payment}}</td>
                        <td>{{$o->transaction_id}}</td>
                        <td>
                            @if($o->payment_status == "Paid")
                            <span class='label label-success'>Paid</span>
                            @else
                            <span class='label label-danger'>{{$o->payment_status}}</span>
                            @endif
                        </td>
                        <td>{!! order_status($o->status) !!}</td>
                    </tr>
                    @endforeach
                    @endif
                </table>
            </div>
        </div>
    </div>
</div>

@endsection

@section('footer_scripts')
<script type="text/javascript">
$(function(){
            $(this).active_menu("customer");
        });
</script>
@stop