<?php $__env->startSection('title','My Profile - Edit'); ?>
<?php $__env->startSection('header_extra'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


<div class="row">
    <div class="col-12">
        <div class="card-box">
            <h4 class="m-t-0 header-title"><b>Profile Edit</b></h4>
            <p class="text-muted m-b-30 font-14">
                Required Fields (<code>*</code>)
            </p>

            <div class="row">
                <div class="col-12">
                    <div class="p-20">
                        <?php echo $__env->make('widget/notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <form class="form-horizontal validate" action="<?php echo e(route('admin.profile_update')); ?>" method="post" role="form" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="rid" value="<?php echo e(Auth::id()); ?>">
                            <div class="form-group row">
                                <label class="col-2 col-form-label">First Name <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="name" class="form-control" required value="<?php echo e($r->name); ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Last Name </label>
                                <div class="col-8">
                                    <input type="text" name="last_name" class="form-control"  value="<?php echo e($r->last_name); ?>">
                                </div>
                            </div>
<!--                            <div class="form-group row">
                                <label class="col-2 col-form-label">Company Name <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="company_name" class="form-control" required value="<?php echo e($r->company_name); ?>">
                                </div>
                            </div>-->
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Phone <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="phone" required="" class="form-control" value="<?php echo e($r->phone); ?>">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Address <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="address" class="form-control" required value="<?php echo e($r->address); ?>">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">City</label>
                                <div class="col-8">
                                    <input type="text" name="city" class="form-control" value="<?php echo e($r->city); ?>">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Province</label>
                                <div class="col-8">
                                    <input type="text" name="state" class="form-control" required value="<?php echo e($r->state); ?>">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Country <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="country" class="form-control" required value="<?php echo e($r->country); ?>">
                                </div>
                            </div>
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Postal <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="text" name="zipcode" class="form-control" required value="<?php echo e($r->zipcode); ?>">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">Picture </label>
                                <div class="col-8">
                                    <input type="file" name="picture" class="form-control"  >
                                </div>
                            </div>
                            <?php if($r->picture): ?>
                            <div class="form-group row">
                                <label class="col-2 col-form-label">&nbsp; </label>
                                <div class="col-8">
                                    <img src="<?php echo e(asset('uploads/profile/'.$r->picture)); ?>" class="thumb-xl">
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            
                            <div class="form-group row <?php echo e($errors->has('email') ? ' has-danger' : ''); ?>">
                                <label class="col-2 col-form-label">Email <span class="text-danger">*</span></label>
                                <div class="col-8">
                                    <input type="email" name="email" class="form-control" required value="<?php echo e($r->email); ?>" id="useremail">
                                    <ul id="parsley-id-5" class="parsley-errors-list filled useremail_exist" style="display: none;">
                                        <li class="parsley-required"> Email Already Exist</li>
                                    </ul>  
                                    <?php if($errors->has('email')): ?>
                                        <div class="form-control-feedback">
                                            <strong><?php echo e($errors->first('email')); ?></strong>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            
                            <div class="form-group row">
                                <label class="col-2 col-form-label">New Password </label>
                                <div class="col-8">
                                    <input type="password" name="new_password" class="form-control" >
                                </div>
                            </div>
                            <div class="form-group row">
                                <div class="col-8 offset-4">
                                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                                        Submit
                                    </button>
                                    
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('assets/plugins/parsleyjs/parsley.min.js')); ?>"></script>

<script type="text/javascript">
    $('.validate').parsley();
    $(function(){
        $(this).active_menu("profile");
    })
    
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mycindia/public_html/portal/project/resources/views/admin/profile_edit.blade.php ENDPATH**/ ?>