<?php $__env->startSection('title','My Profile'); ?>
<?php $__env->startSection('header_extra'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-sm-12">
        <div class="profile-bg-picture">
            <span class="picture-bg-overlay"></span><!-- overlay -->
        </div>
        <!-- meta -->
        <div class="profile-user-box">
            <div class="row">
                
                
                
                <div class="col-sm-4">
                    <span class="pull-left m-r-15">
                        <?php if($r->picture!=""): ?>
                        <img src="<?php echo e(asset('uploads/profile/'.$r->picture)); ?>" alt="" class="thumb-lg rounded-circle">
                        <?php endif; ?>
                    </span>
                    <div class="media-body">
                        <h4 class="m-t-5 m-b-5 font-18 ellipsis"><?php echo e($r->name.' '.$r->last_name); ?></h4>
                        <p class="font-13"> <?php echo e($r->company_name); ?></p>
                        <p class="text-muted m-b-0"><small><?php echo e($r->state. ' '.$r->country); ?></small></p>
                    </div>
                </div>
                
                <div class="col-sm-8">
                    <div class="text-right">
                        <a href="<?php echo e(route('customer.profile_edit')); ?>" class="btn btn-success waves-effect waves-light">
                            <i class="mdi mdi-account-settings-variant m-r-5"></i> Edit Profile
                        </a>
                    </div>
                    
                    <?php $active_subscription =  get_active_subscription(); ?>
                    <?php if(!empty($active_subscription)): ?>
                    <div class="text-right">
                        <h2>Subscribed</h2>
                        <h4>  
                            <span class="label label-success"><?php echo e($active_subscription->name); ?> - <?php echo e(package_information($active_subscription->stripe_plan,'duration')); ?></span>
                        </h4>
                    </div>
                    <?php else: ?>
                    <div class="text-right">
                        <h4><a href="<?php echo e(route('customer.packages')); ?>" class="btn btn-danger">Subscribe Now</a></h4>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="m-t-15 col-12">
                    <?php echo $__env->make('widget/notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                
            </div>
        </div>
        <!--/ meta -->
    </div>
</div>
<div class="row">
    <div class="col-md-6">
        <!-- Personal-Information -->
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Personal Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Full Name :</strong> <span class="m-l-15"><?php echo e($r->name.' '.$r->last_name); ?></span></p>

                    <p class="text-muted font-13"><strong>Mobile :</strong><span class="m-l-15"><?php echo e($r->phone); ?></span></p>

                    <p class="text-muted font-13"><strong>Email :</strong> <span class="m-l-15"><?php echo e($r->email); ?></span></p>

                    <p class="text-muted font-13"><strong>Address :</strong> <span class="m-l-15"><?php echo e($r->address); ?></span></p>
                    
                    
                    <p class="text-muted font-13"><strong>Company Name :</strong> <span class="m-l-15"><?php echo e($r->company_name); ?></span></p>
                    <p class="text-muted font-13"><strong>Web Site :</strong> <span class="m-l-15"><?php echo e($r->website); ?></span></p>
                    <p class="text-muted font-13"><strong>Company Name :</strong> <span class="m-l-15"><?php echo e($r->company_name); ?></span></p>
                    <p class="text-muted font-13"><strong>Company Email :</strong> <span class="m-l-15"><?php echo e($r->company_email); ?></span></p>
                    <p class="text-muted font-13"><strong>Company Phone Number :</strong> <span class="m-l-15"><?php echo e($r->company_phone); ?></span></p>
                    <p class="text-muted font-13"><strong>Number of employee :</strong> <span class="m-l-15"><?php echo e($r->number_employee); ?></span></p>
                    <p class="text-muted font-13"><strong>Privacy Policy Link :</strong> <span class="m-l-15"> <a href="<?php echo e($r->privacy_policy_link); ?>"><?php echo e($r->privacy_policy_link); ?></a> </span></p>
                    
                    
                    <p class="text-muted font-13"><strong>City :</strong> <span class="m-l-15"><?php echo e($r->city); ?></span></p>
                    <p class="text-muted font-13"><strong>Province :</strong> <span class="m-l-15"><?php echo e($r->state); ?></span></p>
                    <p class="text-muted font-13"><strong>Country :</strong> <span class="m-l-15"><?php echo e($r->country); ?></span></p>
                    <p class="text-muted font-13"><strong>Postal :</strong> <span class="m-l-15"><?php echo e($r->zipcode); ?></span></p>
                    <p class="text-muted font-13"><strong>Status :</strong> 
                        <span class="m-l-15">
                            <?php if($r->status == "1"): ?>
                            <span class="label label-success">Active</span>
                            <?php elseif($r->status == "0"): ?>
                            <span class="label label-danger">Disable</span>
                            <?php endif; ?>
                            
                        </span>
                    </p>
                </div>
            </div>
        </div>
        <!-- Personal-Information -->

        

    </div>
    <?php if(!empty($active_subscription)): ?>
    <div class="col-md-6">
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Subscription Information</h4>
            <?php if($r->api_status == 0 ): ?>
            <h4 class="header-title m-t-1 m-b-20"><span class="label label-danger">Your API Service is Stop. Please contact to Admin for resume service.</span></h4>
            <?php endif; ?>
           
            <div class="panel-body">
                <div class="text-left">
                    <?php $pack =  package_information($active_subscription->stripe_plan,''); ?>
                    <p class="text-muted font-13"><strong>Active Date :</strong> <span class="m-l-15"><?php echo e(date('M-d Y h:i a',strtotime($active_subscription->created_at))); ?></span></p>
                    <p class="text-muted font-13"><strong>Package Name :</strong> <span class="m-l-15"><?php echo e($pack->name); ?></span></p>
                    <p class="text-muted font-13"><strong>Duration :</strong> <span class="m-l-15"><?php echo e($pack->duration); ?></span></p>
                    <p class="text-muted font-13"><strong>Price :</strong> <span class="m-l-15"><?php echo e($pack->price); ?></span></p>
                    <?php if($active_subscription->ends_at!=""): ?>
                    <h4 class="header-title m-t-1 m-b-20">
                        <span class="label label-danger"> Subscription will be cancel at <?php echo e(date('M-d Y h:i a',strtotime($active_subscription->ends_at))); ?></span>
                 
                    </h4>
                    <?php endif; ?>
                    <div class="row">
                        <div class="col-md-12 mx-auto">
                            <div class="row">
                                <?php if($active_subscription->ends_at==""): ?>
                                <div class="col-md-5">
                                    <a href="javascript:void(0);" onclick="confirm_cancel('<?=$pack->name?>')" class="btn btn-danger">Cancel Subscription</a>
                                </div>
                                <?php endif; ?>
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card-box">
            <h4 class="header-title mt-0 m-b-20">Card Information</h4>
            <div class="panel-body">
                <div class="text-left">
                    <p class="text-muted font-13"><strong>Card Type :</strong> <span class="m-l-15"><?php echo e(strtoupper($r->card_brand)); ?></span></p>
                    <p class="text-muted font-13"><strong>Card Number :</strong> <span class="m-l-15">XXXX-XXXX-XXXX-<?php echo e($r->card_last_four); ?></span></p>
                    
                </div>
                <div class="row">
                    <div class="col-md-6 mx-auto">
                        <a href="<?php echo e(route('customer.payment.update_card')); ?>" class="btn btn-success">Update card information</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    


    
    <!-- end col -->

</div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer_scripts'); ?>
<script type="text/javascript">
    function confirm_cancel(package){
        var x = confirm('Are you sure you want to cancel subscription ?');
        if(x == true){
            window.location.href='/customer/cancel-subscription/'+package;
        }
    }
    function confirm_cancel_now(package){
        var x = confirm('Are you sure you want cancel subscription now ?');
        if(x == true){
            window.location.href='/customer/cancel-subscription-now/'+package;
        }
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.default', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/aerocodex/public_html/portal/project/resources/views/customer/profile.blade.php ENDPATH**/ ?>